#include <bits/stdc++.h>

using namespace std;

const int MAXN = 15;

char A[MAXN][MAXN], B[MAXN][MAXN];

int n;

void rot90() {
  for (int i = 0; i < n / 2; ++i) {
    for (int j = i; j < n - i - 1; ++j) {
      int tmp = B[i][j];
      B[i][j]                 = B[j][n - i - 1];
      B[j][n - i - 1]         = B[n - i - 1][n - j - 1];
      B[n - i - 1][n - j - 1] = B[n - j - 1][i];
      B[n - j - 1][i]         = tmp;
    }
  }
}

int uncovered() {
  int ret = n * n;
  for (int dr = -n; dr <= n; ++dr) {
    for (int ds = -n; ds <= n; ++ds) {
      int curr = 0;
      for (int i = 0; i < n; ++i) {
        for (int j = 0; j < n; ++j) {
          if (i + dr < 0 || i + dr >= n || j + ds < 0 || j + ds >= n)
            curr += A[i][j] == '#';
          else
            curr += A[i][j] == '#' && B[i + dr][j + ds] != '#';
        }
      }
      ret = min(ret, curr);
    }
  }
  return ret;
}

int main(void) {
  scanf("%d", &n);
  for (int i = 0; i < n; ++i) scanf("%s", A[i]);
  for (int i = 0; i < n; ++i) scanf("%s", B[i]);

  int sol = n * n;
  for (int i = 0; i < 4; ++i) {
    sol = min(sol, uncovered());
    rot90();
  }

  printf("%d\n", sol);
  return 0;
}
